
package com.mcd.restaurant.bundleRelease;

import com.mcd.restaurant.bundledrelease.controller.BundledReleaseControllerAdvice;
import com.mcd.restaurant.bundledrelease.controller.view.response.BundledReleaseAppVersionResponse;
import com.mcd.restaurant.bundledrelease.error.BundleReleaseInvalidRequestException;
import com.mcd.restaurant.bundledrelease.utils.BundleReleaseUtility;
import com.mcd.restaurant.common.ResponseView;
import com.mcd.restaurant.model.Restaurant;
import com.mcd.restaurant.service.ApiLoggingService;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.queryspec.QuerySpec;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.junit.jupiter.api.Assertions.*;
import static org.junit.jupiter.api.Assertions.assertEquals;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
class BundleReleaseUtilityTest {

    private RequestSpecification spec;

    private BundleReleaseUtility bundleReleaseUtility=new BundleReleaseUtility("us-east-1");

    @InjectMocks
    private BundledReleaseControllerAdvice bundledReleaseControllerAdvice;

    @LocalServerPort
    int port;
    @Mock
    private ApiLoggingService apiLoggingService;

    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation).operationPreprocessors()
                        .withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
    void prepareQuerySpecFilterForVersionInBundleAppVersionSuccess() {
        assertNotNull(bundleReleaseUtility.prepareQuerySpecFilterForVersionInBundleAppVersion("abc", "abc-1"));
    }



    @Test
    void testBundledReleaseAppVersionResponse() {
        BundledReleaseAppVersionResponse bundledReleaseAppVersionResponse = new BundledReleaseAppVersionResponse();
        bundledReleaseAppVersionResponse.setBundleReleaseId(2);
        bundledReleaseAppVersionResponse.setPath("abc");
        bundledReleaseAppVersionResponse.setVersion("abc");
        assertNotNull(bundledReleaseAppVersionResponse);
        assertEquals(2, (int) bundledReleaseAppVersionResponse.getBundleReleaseId());
        assertEquals("abc", bundledReleaseAppVersionResponse.getPath());
        assertEquals("abc", bundledReleaseAppVersionResponse.getVersion());
    }

    @Test
    void testidentifyCommonRestaurantSuccess() {
        Restaurant restaurant1 = new Restaurant();
        restaurant1.setId(1);
        List<List<Restaurant>> rLists = Stream.of(Stream.of(restaurant1).collect(Collectors.toList())).collect(Collectors.toList());
        List<Restaurant> restaurants = bundleReleaseUtility.identifyCommonRestaurant(rLists);
        assertEquals(1, restaurants.size());

    }

    @Test
    void testidentifyCommonRestaurantConditionalSuccess() {
        Restaurant restaurant1 = new Restaurant();
        Restaurant restaurant2 = new Restaurant();
        restaurant1.setId(1);
        restaurant2.setId(2);
        List<Restaurant> list1 = Stream.of(restaurant1).collect(Collectors.toList());
        List<Restaurant> list2 = Stream.of(restaurant2).collect(Collectors.toList());
        List<List<Restaurant>> rLists = Stream.of(list1, list2).collect(Collectors.toList());
        List<Restaurant> restaurants = bundleReleaseUtility.identifyCommonRestaurant(rLists);
        assertEquals(0, restaurants.size());

    }

    @Test
    void handleInvalidRequestTest() {
        BundleReleaseInvalidRequestException exception = new BundleReleaseInvalidRequestException("Exception");
        Mockito.when(apiLoggingService.logWarn(exception)).thenReturn("ERRORID");
        ResponseEntity<ResponseView<Object>> response = bundledReleaseControllerAdvice.handleInvalidRequest(exception);
        Assertions.assertEquals(HttpStatus.BAD_REQUEST, response.getStatusCode());
        Assertions.assertEquals("ERRORID", response.getBody().getErrors().get(0).getId());
        Assertions.assertEquals("Exception", response.getBody().getErrors().get(0).getDetail());

    }
}
