package com.mcd.restaurant.bundleRelease;

import com.mcd.restaurant.bundleRelease.testUtils.BundleReleaseTestUtility;
import com.mcd.restaurant.bundledrelease.controller.view.request.BundledReleaseRequest;
import com.mcd.restaurant.bundledrelease.controller.view.request.UpdateBundleDeploymentDetailsRequest;
import com.mcd.restaurant.bundledrelease.controller.view.request.UpdateBundleReleaseRequest;
import com.mcd.restaurant.bundledrelease.controller.view.response.BundleReleaseGenericResponse;
import com.mcd.restaurant.bundledrelease.controller.view.response.BundledReleaseResponse;
import com.mcd.restaurant.bundledrelease.error.BundleNotFoundException;
import com.mcd.restaurant.bundledrelease.error.BundleReleaseGenericException;
import com.mcd.restaurant.bundledrelease.error.BundleReleaseInvalidRequestException;
import com.mcd.restaurant.bundledrelease.service.BundledReleaseService;
import com.mcd.restaurant.bundledrelease.utils.BundleReleaseUtility;
import com.mcd.restaurant.model.BundleRelease;
import com.mcd.restaurant.model.BundleReleaseAppVersion;
import com.mcd.restaurant.repository.BundleReleaseAppVersionRepository;
import com.mcd.restaurant.repository.BundleReleaseRepository;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.ResourceList;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import java.util.ArrayList;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
class BundleReleaseServiceTest {

    @InjectMocks
    private BundledReleaseService bundledReleaseService;
    @Mock
    private BundleReleaseUtility bundleReleaseUtility;
    @InjectMocks
    private BundleReleaseTestUtility bundleReleaseTestUtility;
    @Mock
    private BundleReleaseRepository bundleReleaseRepository;
    @Mock
    private BundleReleaseAppVersionRepository bundleReleaseAppVersionRepository;


    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    void testDeleteBundleWithInvalidReleaseId() {
        Integer releaseId = 1;
        Mockito.when(bundleReleaseUtility.validateDeleteBundleReleaseStatus(releaseId)).thenThrow(ResourceNotFoundException.class);
        assertThrows(BundleNotFoundException.class,
                () -> bundledReleaseService.deleteBundleRelease(releaseId));
    }

    @Test
    void testDeleteBundleSuccess() {
        Integer releaseId = 1;
        ResourceList<BundleReleaseAppVersion> appVersionResourceList = bundleReleaseTestUtility.getBundleAppReleaseList();
        BundleRelease bundleRelease = new BundleRelease();
        QuerySpec querySpec = new QuerySpec(BundleReleaseAppVersion.class);
        Mockito.when(bundleReleaseUtility.validateDeleteBundleReleaseStatus(releaseId)).thenReturn(bundleRelease);
        Mockito.when(bundleReleaseUtility.prepareQuerySpecFilter(releaseId)).thenReturn(querySpec);
        Mockito.when(bundleReleaseAppVersionRepository.findAll(querySpec)).thenReturn(appVersionResourceList);
        Mockito.doNothing().when(bundleReleaseAppVersionRepository).delete(any(int.class));
        Mockito.doNothing().when(bundleReleaseRepository).delete(releaseId);
        Mockito.when(bundleReleaseUtility.generateResponse(appVersionResourceList.size(), new BundleReleaseGenericResponse())).thenCallRealMethod();
        assertTrue(bundledReleaseService.deleteBundleRelease(releaseId).getIsSuccess());
    }

    @Test
    void testSaveBundleReleaseException() {
        BundledReleaseRequest bundledReleaseRequest = new BundledReleaseRequest();
        bundledReleaseRequest.setBundledAppVersionRequestList(new ArrayList<>());
        assertThrows(BundleReleaseGenericException.class,
                () -> bundledReleaseService.saveBundleRelease(bundledReleaseRequest));
    }

    @Test
    void testEditBundleReleaseException() {
        UpdateBundleReleaseRequest updateBundleReleaseRequest = new UpdateBundleReleaseRequest();
        updateBundleReleaseRequest.setReleaseId(100);
        Mockito.when(bundleReleaseUtility.validateBundleReleaseStatus(updateBundleReleaseRequest.getReleaseId())).thenThrow(new BundleReleaseInvalidRequestException("Exception Raised"));
        Exception ex=assertThrows(BundleReleaseInvalidRequestException.class,
                () -> bundledReleaseService.editBundleRelease(updateBundleReleaseRequest));

    }

    @Test
    void testdeleteBundleException() {
        Mockito.when(bundleReleaseUtility.validateBundleReleaseStatus(1)).thenThrow(new BundleReleaseInvalidRequestException("Exception Raised"));
        assertThrows(BundleReleaseGenericException.class,
                () -> bundledReleaseService.deleteBundleRelease(1));
    }

    @Test
    void testdeleteBundleExceptionGeneric() {
        try {
            Mockito.when(bundleReleaseUtility.validateBundleReleaseStatus(1)).thenThrow(new NullPointerException());
            bundledReleaseService.deleteBundleRelease(1);
        } catch (BundleReleaseGenericException e) {
            assertEquals("Some Exception occurred", e.getMessage());
        }
    }

    @Test
    void testEditBundleReleaseGenericException() {
        try {
            UpdateBundleReleaseRequest updateBundleReleaseRequest = new UpdateBundleReleaseRequest();
            updateBundleReleaseRequest.setReleaseId(100);
            Mockito.when(bundleReleaseUtility.validateBundleReleaseStatus(updateBundleReleaseRequest.getReleaseId())).thenThrow(new NullPointerException());
            bundledReleaseService.editBundleRelease(updateBundleReleaseRequest);
        } catch (BundleReleaseGenericException e) {
            assertEquals("Some Exception occurred", e.getMessage());
        }
    }

    @Test
    void testCreateBundleReleaseGenericException() {
        try {
            final BundledReleaseRequest mockedReleaseRequest = Mockito.mock(BundledReleaseRequest.class, Mockito.RETURNS_DEEP_STUBS);
            BundledReleaseRequest bundledReleaseRequest = bundleReleaseTestUtility.prepareBundleReleaseRequestSuccess();
            Mockito.when(mockedReleaseRequest.getBundledAppVersionRequestList()).thenThrow(new NullPointerException());
            bundledReleaseService.saveBundleRelease(bundledReleaseRequest);
        } catch (BundleReleaseGenericException e) {
            assertEquals("Some Exception occurred", e.getMessage());
        }
    }

    @Test
    void testCreateBundleReleaseNullPointerException() {
        try {
            BundledReleaseRequest bundledReleaseRequest = bundleReleaseTestUtility.prepareBundleReleaseRequestSuccess();
            Mockito.when(bundleReleaseUtility.generateResponse(Mockito.anyInt(), Mockito.any(BundledReleaseResponse.class))).thenThrow(new NullPointerException());
            bundledReleaseService.saveBundleRelease(bundledReleaseRequest);
        } catch (BundleReleaseGenericException e) {
            assertEquals("Some Exception occurred", e.getMessage());
        }
    }

    @Test
    void testEditDeploymentDetailForBundleNullPointer(){
        try {
            bundledReleaseService.editDeploymentDetailForBundle(new UpdateBundleDeploymentDetailsRequest());
        } catch (BundleReleaseGenericException e) {
            assertEquals("Some Exception occurred", e.getMessage());
        }
    }
}

