package com.mcd.restaurant;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import net.minidev.json.JSONObject;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import static org.hamcrest.CoreMatchers.is;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
 class ReipOnboardingJobTests {

    private RequestSpecification spec;

    @LocalServerPort
    int port;

    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation).operationPreprocessors()
                        .withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
     void getReipOnboardingJobWhenIDIsInvalid() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/reip_onboarding_jobs/123")
                .then().assertThat().statusCode(is(404));
    }

    @Test
     void getReipOnboardingJobWhenIDIsNull() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/reip_onboarding_jobs/null")
                .then().assertThat().statusCode(is(500));
    }

    @Test
     void getReipOnboardingJobWhenIDIsMissing() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/reip_onboarding_jobs/").then()
                .statusCode(is(200));
    }

    @Test
     void postReipOnboardingJobWhenInputJSONIsEmpty() {
        String jsonBody = "";

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
                .post("/restaurant_assets/reip_onboarding_jobs").then().assertThat().statusCode(is(400));
    }

    @Test
     void postReipOnboardingJobWhenInputJSONIsInvalid() {
        String jsonBody = "{}";

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
                .post("/restaurant_assets/reip_onboarding_jobs").then().assertThat().statusCode(is(400));
    }

    @Test
     void postReipOnboardingJobWhenInputJSONIsValid() {
        JSONObject body = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("name", "Job1");
        attributeJSON.put("status", "Initiated");
        attributeJSON.put("submittedBy", "TestUser1");
        attributeJSON.put("fileData", "asdaddadsadsada");
        attributeJSON.put("email", "TestUser1@abc.com");
        attributeJSON.put("created", "2022-11-29T22:30:22.000+00:00");
        // fill data JSON
        dataJSON.put("type", "reip_onboarding_jobs");
        dataJSON.put("attributes", attributeJSON);
        body.put("data", dataJSON);
        System.out.println(body);
        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/reip_onboarding_jobs").then().assertThat().statusCode(is(201));
    }
}