package com.mcd.restaurant;

import com.mcd.restaurant.model.ComponentView;
import com.mcd.restaurant.repository.ComponentViewRepository;
import io.crnk.core.exception.MethodNotAllowedException;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
class ComponentViewTest {

    private RequestSpecification spec;

    @InjectMocks
    private ComponentViewRepository componentViewRepository;

    @LocalServerPort
    int port;

    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation)
                        .operationPreprocessors().withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
    void getComponentViewTypeWhenIDIsInvalid() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/deviceDetails/123").then()
                .assertThat().statusCode(is(404));
    }

    @Test
    void getComponentViewWhenIDIsNull() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/deviceDetails/null").then()
                .assertThat().statusCode(is(500));
    }

    @Test
    void getComponentViewWhenIDIsMissing() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/deviceDetails/").then()
                .statusCode(is(200));
    }

    @Test
    void testComponentViewCreate() {
        ComponentView componentView=new ComponentView();
        assertThrows(MethodNotAllowedException.class,
                () -> componentViewRepository.create(componentView));
    }

    @Test
    void testComponentViewsave() {
        ComponentView componentView=new ComponentView();
        assertThrows(MethodNotAllowedException.class,
                () -> componentViewRepository.save(componentView));
    }

    @Test
    void testComponentViewDelete() {

        assertThrows(MethodNotAllowedException.class,
                () -> componentViewRepository.delete(1));
    }

    @Test
    void testComponentViewModel() {
        String common = "abc";
        ComponentView componentView = new ComponentView();
        componentView.setDeviceName(common);
        componentView.setDisplayName(common);
        componentView.setIdentificationName(common);
        componentView.setFirmwareVersion(common);
        componentView.setHardwareVersion(common);
        componentView.setId(1);
        componentView.setModelNumber(common);
        componentView.setOnboardingStatus(common);
        componentView.setSerialNumber(common);
        componentView.setStoreName(common);
        componentView.setVendorName(common);
        assertEquals(1, (int) componentView.getId());
        assertEquals(common, componentView.getDeviceName());
        assertEquals(common, componentView.getDisplayName());
        assertEquals(common, componentView.getIdentificationName());
        assertEquals(common, componentView.getFirmwareVersion());
        assertEquals(common, componentView.getHardwareVersion());
        assertEquals(common, componentView.getModelNumber());
        assertEquals(common, componentView.getOnboardingStatus());
        assertEquals(common, componentView.getSerialNumber());
        assertEquals(common, componentView.getStoreName());
        assertEquals(common, componentView.getVendorName());


    }

}
