-- Seed the data expected by Opentest into the database.

-- Assumptions:
-- A MySQL database named opentest exists
-- The MYSQL_DATASOURCE_URL, MYSQL_DATASOURCE_USERNAME, and MYSQL_DATASOURCE_PASSWORD environment variables have been set appropriately (MYSQL_DATASOURCE_URL=jdbc:mysql://localhost:3306/opentest if running locally on the default port)
-- The service has started successfully (table creation should happen automatically when the service starts)


USE opentest;
INSERT INTO owner_operators(id,name,contact_info_type,contact_info,bre_subscription,onsite_support_engineer,preferences,created,updated) VALUES (1,'Jane','email','jane@foo','bar','John','foo','2020-01-01 00:00:00','2020-01-01 00:00:00');
INSERT INTO vendors(id,created,name,updated,notes) VALUES (1,'2020-01-01 00:00:00','Test Vendor','2020-01-01 00:00:00','Notes1');
INSERT INTO vendors(id,created,name,updated,notes) VALUES (2,'2020-01-01 00:00:00','Test Vendor2','2020-01-01 00:00:00','Notes2');
INSERT INTO markets(id,name,type,created,updated) VALUES (1,'Chicago','test','2020-01-01 00:00:00','2020-01-01 00:00:00');
INSERT INTO markets(id,name,type,created,updated) VALUES (2,'Market2','test','2020-01-01 00:00:00','2020-01-01 00:00:00');
INSERT INTO component_groups(id,name,type,version,created,updated) VALUES (1,'Test Component Group','Component Group Type',1,'2020-01-01 00:00:00','2020-01-01 00:00:00');
INSERT INTO restaurants(id,name,created,description,updated,market_id,owner_operator_id) VALUES (1,'McDonald''s Global Menu Restaurant (HQ)','2020-01-01 00:00:00','Test Description','2020-01-01 00:00:00',1,1);
INSERT INTO restaurants(id,name,created,description,updated,market_id,owner_operator_id) VALUES (2,'Restaurant 2','2020-01-01 00:00:00','Test Description 2','2020-01-01 00:00:00',2,1);
INSERT INTO components(id,name,restaurant_id,model_number,serial_number,display_name) VALUES (1,'TestComponent',1,1,123,'TestComponentDisplayName');
INSERT INTO components(id,name,restaurant_id,model_number,serial_number,display_name) VALUES (2,'TestComponent2',2,2,234,'TestComponentDisplayName');
INSERT INTO component_type(id,description,name) VALUES (1,'Test Component Type 1','Test Component Type 1 Description');
INSERT INTO component_type(id,description,name) VALUES (2,'Test Component Type 2','Component Type To Delete');
INSERT INTO component_type(id,description,name) VALUES (3,'Test Component Type 3','Component Type To Patch');
INSERT INTO component_type(id,description,name) VALUES (4,'Test Component Type 3','docker');
INSERT INTO component_properties_type(id,description,name) VALUES (1,'Test Component Properties Type 1','Test Component Properties Type 1 Description');
INSERT INTO component_properties_type(id,description,name) VALUES (2,'Test Component Properties Type 2','Component Properties Type To Delete');
INSERT INTO component_properties_type(id,description,name) VALUES (3,'Test Component Properties Type 3','Component Properties Type To Patch');
INSERT INTO vendor_type(id,description,name) VALUES (1,'Test Vendor Type 1','Test Vendor Type Description 1');
INSERT INTO vendor_type(id,description,name) VALUES (2,'Test Vendor Type 2','Vendor Type To Delete');
INSERT INTO vendor_type(id,description,name) VALUES (3,'Test Vendor Type 3','Vendor Type To Patch');
INSERT INTO deployment_groups(id,created,updated) VALUES (1,'2021-04-30 00:00:00','2021-04-30 00:00:00');
INSERT INTO deployment_history(id,created,status,updated,component_id,deployment_group_id,restaurant_id,application_name,application_version) VALUES (1,'2021-04-30 00:00:00','Completed','2021-04-30 00:00:00',1,1,1,'svcs-asset','1.0.0');
INSERT INTO bundle_release (id,release_name,created_by,status, updated_by, release_date) VALUES (1, 'R-1','John Doe','CREATED','John Doe','2021-09-09 00:00:00');
INSERT INTO bundle_release_app_version (id,bundle_release_id,app_name,version) VALUES (1, 1,'App_1','App_1_version1');
INSERT INTO bre_hierarchy_nodes (id,node_name,hierarchy_level) VALUES (1, 'Chicago',3000);
INSERT INTO bre_hierarchy_nodes (id,node_name,hierarchy_level) VALUES (2, 'Market2',3000);
