package com.mcd.restaurant.repository;

import com.mcd.restaurant.bundledrelease.controller.view.request.BundledAppVersionRequest;
import com.mcd.restaurant.model.ProductApplications;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.queryspec.Direction;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class ProductApplicationRepository extends JpaEntityRepositoryBase<ProductApplications, Integer> {

    public static final String DELETE_QUERY = "DELETE FROM `breservicesdb`.`product_applications`  WHERE (`product_version_id` = '%d')";

    public ProductApplicationRepository() {
        super(ProductApplications.class);
    }

    public Integer deleteWithNativeQuery(Integer id) {
        return this.getEntityManager().createNativeQuery(String.format(DELETE_QUERY, id)).executeUpdate();
    }

    public List<ProductApplications> getAllApplication() {
        QuerySpec querySpec = new QuerySpec(ProductApplications.class);
        return this.findAll(querySpec);
    }

    public List<ProductApplications> getAllApplicationByName(String applicationName) {
        QuerySpec querySpec = new QuerySpec(ProductApplications.class);
        querySpec.addFilter(PathSpec.of("applicationName").filter(FilterOperator.EQ, applicationName));
        return this.findAll(querySpec);
    }

    public List<ProductApplications> getAllApplicationByNameAndVersion(List<BundledAppVersionRequest> requests) {
        QuerySpec querySpec = new QuerySpec(ProductApplications.class);
        List<FilterSpec> filterSpecList = new ArrayList<>();
        requests.forEach(app -> {
            FilterSpec filterNameSpec = new FilterSpec(PathSpec.of("applicationName"), FilterOperator.EQ, app.getAppName());
            FilterSpec filterVersionSpec = new FilterSpec(PathSpec.of("applicationVersion"), FilterOperator.EQ, app.getAppVersion());
            filterSpecList.add(FilterSpec.and(Stream.of(filterNameSpec, filterVersionSpec).collect(Collectors.toList())));
        });
        SortSpec sortSpec = PathSpec.of("updated").sort(Direction.DESC);
        querySpec.addFilter(FilterSpec.or(filterSpecList));
        querySpec.setSort(Stream.of(sortSpec).collect(Collectors.toList()));
        return this.findAll(querySpec);
    }


}