package com.mcd.restaurant.repository;

import com.mcd.restaurant.deployment.service.PreCheckStatus;
import com.mcd.restaurant.model.DeploymentHistory;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class DeploymentHistoryRepository extends JpaEntityRepositoryBase<DeploymentHistory, Integer> {
	public DeploymentHistoryRepository() {
		super(DeploymentHistory.class);
	}


	public List<DeploymentHistory> getHistoryByGroupId(Integer groupId) {
		QuerySpec querySpec = new QuerySpec(DeploymentHistory.class);
		FilterSpec filterGroupSpec = new FilterSpec(PathSpec.of("deployment_group.id"), FilterOperator.EQ, groupId);
		FilterSpec filterPreCheckStatusPassed = new FilterSpec(PathSpec.of("selectedStatus"), FilterOperator.EQ, PreCheckStatus.PASSED.value());
		FilterSpec filterPreCheckStatusUserApproved = new FilterSpec(PathSpec.of("selectedStatus"), FilterOperator.EQ, PreCheckStatus.USER_APPROVED.value());
		FilterSpec filterPreCheckStatusSpec = FilterSpec.or(Stream.of(filterPreCheckStatusPassed,filterPreCheckStatusUserApproved).collect(Collectors.toList()));
		FilterSpec filterFinalType = FilterSpec.and(Stream.of(filterPreCheckStatusSpec,filterGroupSpec).collect(Collectors.toList()));
		querySpec.setFilters(Stream.of(filterFinalType).collect(Collectors.toList()));
		return this.findAll(querySpec);
	}

	public List<DeploymentHistory> getHistoryByGroupIdAndRestaurantIdAndApplicationNameAndApplicationVersion(Integer groupId,Integer restaurantId,String applicationName,String applicationVersion) {
		QuerySpec querySpec = new QuerySpec(DeploymentHistory.class);
		FilterSpec filterGroupSpec = new FilterSpec(PathSpec.of("deployment_group.id"), FilterOperator.EQ, groupId);
		FilterSpec filterRestaurantIdSpec = new FilterSpec(PathSpec.of("restaurant.id"), FilterOperator.EQ, restaurantId);
		FilterSpec filterApplicationNameSpec = new FilterSpec(PathSpec.of("applicationName"), FilterOperator.EQ, applicationName);
		FilterSpec filterApplicationVersionSpec = new FilterSpec(PathSpec.of("applicationVersion"), FilterOperator.EQ, applicationVersion);
		FilterSpec filterFinalType = FilterSpec.and(Stream.of(filterGroupSpec, filterRestaurantIdSpec,filterApplicationNameSpec,filterApplicationVersionSpec).collect(Collectors.toList()));
		querySpec.setFilters(Stream.of(filterFinalType).collect(Collectors.toList()));
		return this.findAll(querySpec);
	}
}
