package com.mcd.restaurant.repository;

import com.mcd.restaurant.model.DeploymentGroup;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class DeploymentGroupRepository extends JpaEntityRepositoryBase<DeploymentGroup, Integer> {
    public DeploymentGroupRepository() {
        super(DeploymentGroup.class);
    }

    public QuerySpec prepareQuerySpecFilterForGraph(String status, Long startTime, Long endTime) {
        QuerySpec querySpec = new QuerySpec(DeploymentGroup.class);
        FilterSpec filterExtremeDate = new FilterSpec(PathSpec.of("created"), FilterOperator.LT, new Timestamp(endTime));
        FilterSpec filterMinimumDate = new FilterSpec(PathSpec.of("created"), FilterOperator.GE, new Timestamp(startTime));
        FilterSpec filterStatus = new FilterSpec(PathSpec.of("deploymentHistory.status"), FilterOperator.EQ, status);
        FilterSpec finalFilter = FilterSpec.and(Stream.of(filterStatus, filterExtremeDate, filterMinimumDate).collect(Collectors.toList()));
        querySpec.setFilters(Stream.of(finalFilter).collect(Collectors.toList()));

        return querySpec;
    }
}
