package com.mcd.restaurant.reip.controller;


import com.mcd.restaurant.common.ErrorCode;
import com.mcd.restaurant.common.ResponseView;
import com.mcd.restaurant.reip.error.RestaurantEdgeIOTBadRequestException;
import com.mcd.restaurant.reip.error.RestaurantEdgeIOTException;
import com.mcd.restaurant.service.ApiLoggingService;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.ErrorDataBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

/**
 * ControllerAdvice responsible for handling error for store-dashboard module
 */
@ControllerAdvice
public class RestaurantEdgeIOTControllerAdvice extends ResponseEntityExceptionHandler {


    @Autowired
    private ApiLoggingService apiLoggingService;

    @ExceptionHandler(RestaurantEdgeIOTException.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handlesRestaurantEdgeIOTException(RestaurantEdgeIOTException ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.RESTAURANT_EDGE_IOT_EXCEPTION)
                .setStatus(Integer.toString(HttpStatus.INTERNAL_SERVER_ERROR.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(responseView);
    }

    @ExceptionHandler(RestaurantEdgeIOTBadRequestException.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handlesStoredashboardBadRequestException(RestaurantEdgeIOTBadRequestException ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.RESTAURANT_EDGE_IOT_BAD_REQUEST_EXCEPTION)
                .setStatus(Integer.toString(HttpStatus.BAD_REQUEST.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(responseView);
    }

}
