package com.mcd.restaurant.productversions.utils;


import com.mcd.restaurant.common.MapperUtils;
import com.mcd.restaurant.deployment.service.DeploymentType;
import com.mcd.restaurant.model.ProductApplications;
import com.mcd.restaurant.model.ProductVersions;
import com.mcd.restaurant.model.Products;
import com.mcd.restaurant.productversions.controller.view.request.ProductApplicationRequestDTO;
import com.mcd.restaurant.productversions.controller.view.request.CreateProductRequestDTO;
import com.mcd.restaurant.productversions.controller.view.response.ProductResponseDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class ProductDeploymentUtility {
    @Autowired
    private MapperUtils mapperUtils;

    public Products buildProducts(CreateProductRequestDTO createProductRequestDTO) {
        return Products.builder().name(createProductRequestDTO.getProductName()).build();
    }

    public ProductVersions buildProductVersions(Products products, String versionName) {
        return ProductVersions
                .builder()
                .products(products)
                .versionName(versionName)
                .build();
    }

    public ProductApplications buildProductApplication(ProductApplicationRequestDTO productApplicationRequestDTO, ProductVersions productVersions) {
        return ProductApplications.builder().applicationName(productApplicationRequestDTO.getApplicationName().trim())
                .applicationVersion(productApplicationRequestDTO.getApplicationVersion()).applicationUrl(productApplicationRequestDTO.getApplicationURL())
                .applicationType(productApplicationRequestDTO.getType() != null ? productApplicationRequestDTO.getType().name() : DeploymentType.docker.name())
                .productVersions(productVersions).build();
    }


    public ProductResponseDTO buildProductVersionResponse(Products product, ProductVersions productVersions, List<ProductApplications> applicationsList) {
        productVersions.setProductApplications(applicationsList);
        product.setProductVersions(Stream.of(productVersions).collect(Collectors.toList()));
        return mapperUtils.map(product, ProductResponseDTO.class);
    }




}

