package com.mcd.restaurant.model;

import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.Data;
import lombok.Getter;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Immutable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.sql.Timestamp;

@Data
@Getter
@Entity
@Immutable
@Table(name = "restaurant_view")
@JsonApiResource(type = "restaurantDetails", postable = false, readable = true, patchable = false, deletable = false,
        sortable = true, filterable = true)
public class RestaurantView {

    @Id
    private Integer id;
    private Integer hierarchyNodeId;
    private Integer storeDashboardId;
    @Column(name = "no_of_lanes")
    private Integer numberOfLanes;
    @Column(name = "storeStatus")
    private String storeStatus;
    @Column(name = "nodeName")
    private String nodeName;
    @Column(name = "restaurant_no")
    private String restaurantNo;
    @Column(name = "ip_address")
    private String ipAddress;
    @Column(name = "store_address")
    private String storeAddress;
    @Column(name = "latitude")
    private Double latitude;
    @Column(name = "longitude")
    private Double longitude;
    @Column(name = "city")
    private String city;
    @Column(name = "state")
    private String state;
    @Column(name = "country")
    private String country;
    @Column(name = "zip_code")
    private String zipCode;
    @Column(name = "operational_hours")
    private String operationalHours;
    @Column(name = "contact_number")
    private String contactNumber;
    @Column(name = "owner_name")
    private String ownerName;
    @Column(name = "owner_type")
    private String ownerType;
    private String marketName;
    private String regionName;
    private String coopName;
    private Timestamp created;
    private Timestamp updated;
    private Integer marketNodeId;
    private Integer regionNodeId;
    private Integer coopNodeId;

}
