package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

@Entity
@Data
@Table(name="reip_prop_list", indexes={@Index(name="reip_prop_list_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "reip_prop_list")
public class ReipPropList implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(unique = true,nullable=false)
    private String propName;

    @Column(name = "is_adapter_prop")
    private String isAdapterProp;

    @Column(name = "is_device_prop")
    private String isDeviceProp;
}