package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name = "reip_job_validation", indexes = {@Index(name = "reip_job_validation_id_IX", columnList = "id", unique = true)})
@Builder
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@JsonApiResource(type = "reip_job_validation")
public class ReipJobValidation implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable = false)
    private String row_id;

    @Column(nullable=false)
    private String device_name;

    @Column(nullable=false)
    private String missing_values;

    @Column(nullable=false)
    private String invalid_values;

    @ManyToOne
    @JoinColumn(name = "reip_job_id", nullable = false)
    @JsonIgnoreProperties("reipJobValidations")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ReipOnboardingJob reipOnboardingJob;
}