package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;

@Entity
@Builder
@Data
@Table(name="reip_device_instances_props", indexes={@Index(name="reip_device_instances_props_id_IX", columnList="id", unique=true)})
@AllArgsConstructor
@NoArgsConstructor
@JsonApiResource(type = "reip_device_instances_props")
public class ReipDeviceInstanceProps implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable=false, name = "prop_name")
    private String propName;

    @Column(nullable=false, name = "prop_value")
    private String propValue;

    @ManyToOne
    @JoinColumn(name="device_instance_id", nullable=false)
    @JsonIgnoreProperties("reipDeviceInstanceProps")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ReipDeviceInstances reipDeviceInstances;
}