package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name = "reip_device_adapter_mapping", indexes = {@Index(name = "reip_device_adapter_mapping_id_IX", columnList = "id", unique = true)})
@AllArgsConstructor
@NoArgsConstructor
@Builder
@JsonApiResource(type = "reip_device_adapter_mapping")
public class ReipDeviceAdapterMapping implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(name = "created_by")
    private String createdBy;

    @Column(name = "updated_by")
    private String updatedBy;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @ManyToOne
    @JoinColumn(name = "adapter_instance_id", nullable = false)
    @JsonIgnoreProperties("reipAdapterInstanceMapping")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ReipDeviceInstances reipAdapterInstance;

    @ManyToOne
    @JoinColumn(name = "device_instance_id")
    @JsonIgnoreProperties("reipDeviceInstanceMapping")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ReipDeviceInstances reipDeviceInstance;

    @ManyToOne
    @JoinColumn(name = "reip_device_type_prop_id", nullable = false)
    @JsonIgnoreProperties("reipDeviceAdapterMapping")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ReipDeviceTypeProps reipDeviceTypeProps;
}