package com.mcd.restaurant.model;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name="device_props", indexes={@Index(name="device_props_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "device_props")
public class DeviceProp implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;
    
    @Column(name="property_name", nullable=false)
    private String propertyName;
    
    @Column(name="data_type", nullable=false)
    private String dataType;
    
    @CreationTimestamp
    private Timestamp created;
    
    @ManyToOne
    @JoinColumn(name="device_id", nullable=false)
    @JsonIgnoreProperties("deviceProps")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Device device;
}