package com.mcd.restaurant.model;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Entity
@Data
@Table(name = "deployment_history", indexes = {
        @Index(name = "deployment_history_id_IX", columnList = "id", unique = true)}, uniqueConstraints = @UniqueConstraint(columnNames = {
        "component_id", "deployment_group_id"}))
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "deployment_history")
public class DeploymentHistory {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(name = "status")
    private String status;

    @Column(name = "type")
    private String type;

    @Column(name = "application_name")
    private String applicationName;

    @Column(name = "application_version")
    private String applicationVersion;

    @Column(name = "pre_check_status")
    private String preCheckStatus;

    @Column(name = "selected_status")
    private String selectedStatus;

    @Column(name = "modified_by")
    private String modifiedBy;

    @Column(name = "description")
    private String description;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToOne
    @JsonIgnoreProperties("deploymentHistory")
    @JoinColumn(name = "component_id", nullable = false)
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Component component;

    @ManyToOne
    @JoinColumn(name = "deployment_group_id", nullable = false)
    @JsonIgnoreProperties("deploymentHistory")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private DeploymentGroup deployment_group;

    @ManyToOne
    @JoinColumn(name = "restaurant_id", updatable = false)
    @JsonIgnoreProperties("deploymentHistory")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Restaurant restaurant;

    @ManyToOne
    @JoinColumn(name = "product_version_id")
    @JsonIgnoreProperties("deploymentHistory")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ProductVersions productVersions;

}
