package com.mcd.restaurant.model;


import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;

import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name="contacts", indexes={@Index(name="contacts_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "contacts")
public class Contacts implements Serializable {
    @Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable=false)
    private String contact_name;

    @Column(nullable=false)
    private String phone_number;

    @Column(nullable=false)
    private String email_id;

    @Column(name="is_MCD", nullable=false)
    private Boolean is_MCD;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;
}