package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name = "component_groups", indexes = {@Index(name = "component_groups_id_IX", columnList = "id", unique = true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "component_groups")
public class ComponentGroup implements Serializable {

    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable = false)
    private String name;

    @Column
    private String type;

    @Column
    private int version;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToMany(mappedBy = "componentGroup")
    @JsonIgnoreProperties("componentGroup")
    @JsonApiRelation(mappedBy = "componentGroup")
    @ToString.Exclude
    private List<Component> components;
}
