package com.mcd.restaurant.model;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name="bundle_release_app_version", indexes={@Index(name="bundle_release_app_version_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "bundle_release_app_version")
public class BundleReleaseAppVersion implements Serializable {
    @Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @ManyToOne
    @JoinColumn(name="bundle_release_id", nullable=false)
    @JsonIgnoreProperties("bundleRelease")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private BundleRelease bundleRelease;


    @Column(name="app_name",nullable = false)
    private String appName;

    @Column(name="version",nullable=false)
    private String version;

    @Column(name="artifactory_path")
    private String artifactoryPath;

    @ManyToOne
    @JoinColumn(name = "product_version_id")
    @JsonIgnoreProperties("bundleReleaseApp")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ProductVersions productVersions;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

}