package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name="app", indexes={@Index(name="app_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "app")
public class App implements Serializable {
    @Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable=false)
    private String name;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToMany(mappedBy="app")
    @JsonIgnoreProperties("app")
    @JsonApiRelation(mappedBy = "app")
    @ToString.Exclude
    private List<TemplateApp> templateApps;

    @OneToMany(mappedBy="app")
    @JsonIgnoreProperties("app")
    @JsonApiRelation(mappedBy = "app")
    @ToString.Exclude
    private List<BundleReleaseAppVersion> bundleReleaseAppVersions;
}