package com.mcd.restaurant.deployment.controller.view.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mcd.restaurant.deployment.controller.view.request.DeployRequest;
import com.mcd.restaurant.model.DeploymentGroup;
import com.mcd.restaurant.model.DeploymentHistory;
import lombok.Data;

import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Data
public class DeployResponse {
    private Integer tagId;
    private String tagName;
    private List<DeployComponentResponse> deploymentIds;
    private Set<Integer> restaurantIds;
    private Timestamp scheduledAt;

    @JsonIgnore
    private List<DeploymentHistory> deploymentHistories;
    @JsonIgnore
    private DeploymentGroup deploymentGroup;

    public static DeployResponse build(DeployRequest request, DeploymentGroup deploymentGroup, List<DeploymentHistory> histories) {
        DeployResponse deployResponse = new DeployResponse();
        deployResponse.setDeploymentIds(request.getDeployComponents().stream().map(it ->
                DeployComponentResponse.build(it, deploymentGroup.getId(), request.getDeploymentType())).collect(Collectors.toList()));
        deployResponse.setTagId(deploymentGroup.getDeploymentTag().getId());
        deployResponse.setTagName(deploymentGroup.getDeploymentTag().getName());
        deployResponse.setRestaurantIds(request.getRestaurantIds());
        deployResponse.setScheduledAt(request.getScheduledAt());
        deployResponse.setDeploymentHistories(histories);
        deployResponse.setDeploymentGroup(deploymentGroup);
        return deployResponse;
    }
}
