package com.mcd.restaurant.deployment.controller.view.beans;

import com.mcd.restaurant.deployment.service.DeploymentType;
import com.mcd.restaurant.model.ComponentType;
import com.mcd.restaurant.model.DeploymentGroup;
import com.mcd.restaurant.model.ProductVersions;
import com.mcd.restaurant.model.Restaurant;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.NoArgsConstructor;

import java.util.Map;

@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DeploymentHelper {
    private DeploymentType deploymentType;
    private Map<Integer, ProductVersions> versionsMap;
    private Boolean isProductDeployment;
    private Map<Integer, Restaurant> selectedRestaurantMap;
    private ComponentType type;
    private DeploymentGroup deploymentGroup;

    public DeploymentType getDeploymentType() {
        return deploymentType;
    }

    public Map<Integer, ProductVersions> getVersionsMap() {
        return versionsMap;
    }

    public Boolean getIsProductDeployment() {
        return isProductDeployment;
    }

    public Map<Integer, Restaurant> getSelectedRestaurantMap() {
        return selectedRestaurantMap;
    }

    public ComponentType getType() {
        return type;
    }

    public DeploymentGroup getDeploymentGroup() {
        return deploymentGroup;
    }

}
