package com.mcd.restaurant.deployment.controller;

import com.mcd.restaurant.common.ErrorCode;
import com.mcd.restaurant.common.ResponseView;
import com.mcd.restaurant.deployment.error.ComponentNotApplicableError;
import com.mcd.restaurant.deployment.error.DeploymentBadRequestException;
import com.mcd.restaurant.deployment.error.DeploymentError;
import com.mcd.restaurant.service.ApiLoggingService;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.ErrorDataBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

/**
 * ControllerAdvice responsible for handling error for deployment module
 */
@ControllerAdvice
public class DeployControllerAdvice extends ResponseEntityExceptionHandler {

    @Autowired
    private ApiLoggingService apiLoggingService;

    @ExceptionHandler(ComponentNotApplicableError.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handleInvalidComponent(ComponentNotApplicableError ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.D_400_COMPONENT_NOT_APPLICABLE)
                .setStatus(Integer.toString(HttpStatus.BAD_REQUEST.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(responseView);
    }

    @ExceptionHandler(DeploymentBadRequestException.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handleBadRequest(DeploymentBadRequestException ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.BAD_REQUEST)
                .setStatus(Integer.toString(HttpStatus.BAD_REQUEST.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(responseView);
    }

    @ExceptionHandler(DeploymentError.class)
    @ResponseBody
    public ResponseEntity<ResponseView<Object>> handleDeploymentError(DeploymentError ex) {
        String errorId = apiLoggingService.logWarn(ex);
        ErrorDataBuilder builder = ErrorData.builder()
                .setId(errorId)
                .setCode(ErrorCode.DEPLOYMENT_ERROR)
                .setStatus(Integer.toString(HttpStatus.INTERNAL_SERVER_ERROR.value()))
                .setDetail(ex.getMessage());
        ResponseView<Object> responseView = new ResponseView<>();
        responseView.addError(builder.build());
        return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body(responseView);
    }

}
