package com.mcd.restaurant.configuration;

import com.amazonaws.services.lambda.AWSLambdaAsync;
import com.amazonaws.services.lambda.AWSLambdaAsyncClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AwsConfig {
    @Value("${aws.sqs.queue.region}")
    String regionValue;
    @Bean
    public AmazonS3 s3Client() {
               return AmazonS3ClientBuilder.standard()
                .withRegion(regionValue).build();
    }

    @Bean
    public AWSLambdaAsync lambdaClient() {
        return AWSLambdaAsyncClientBuilder.standard()
                .withRegion(regionValue).build();
    }
}
