package com.mcd.restaurant.bundledrelease.service;

import com.mcd.restaurant.bundledrelease.controller.view.request.BundledAppVersionRequest;
import com.mcd.restaurant.bundledrelease.controller.view.request.BundledReleaseRequest;
import com.mcd.restaurant.bundledrelease.enums.BundleType;
import com.mcd.restaurant.model.BundleRelease;
import com.mcd.restaurant.model.BundleReleaseAppVersion;
import com.mcd.restaurant.model.ProductVersions;
import io.crnk.core.engine.internal.utils.StringUtils;
import org.springframework.util.CollectionUtils;

/**
 * Utility to Build Bundle Release Objects.
 */
public final class BundledReleaseBuilder {
    private BundledReleaseBuilder() {
        // private constructor
    }

    public static BundleRelease buildBundleRelease(BundledReleaseRequest bundledReleaseRequest) {
        BundleRelease bundleRelease = new BundleRelease();
        bundleRelease.setReleaseName(bundledReleaseRequest.getReleaseName());
        bundleRelease.setCreatedBy(bundledReleaseRequest.getCreatedBy());
        bundleRelease.setUpdatedBy(bundledReleaseRequest.getCreatedBy());
        bundleRelease.setStatus(bundledReleaseRequest.getStatus().value());
        if (!CollectionUtils.isEmpty(bundledReleaseRequest.getProductVersionIdList())) {
            bundleRelease.setType(BundleType.PRODUCTS.value());
        } else {
            bundleRelease.setType(BundleType.APPLICATIONS.value());
        }
        return bundleRelease;
    }

    public static BundleReleaseAppVersion buildBundleReleaseAppVersion(BundledAppVersionRequest bundledAppVersionRequest, BundleRelease bundleRelease, ProductVersions versions) {
        BundleReleaseAppVersion bundleReleaseAppVersion = new BundleReleaseAppVersion();
        if (!StringUtils.isBlank(bundledAppVersionRequest.getAppName())) {
            bundleReleaseAppVersion.setAppName(bundledAppVersionRequest.getAppName());
        }
        bundleReleaseAppVersion.setBundleRelease(bundleRelease);
        bundleReleaseAppVersion.setVersion(bundledAppVersionRequest.getAppVersion());
        bundleReleaseAppVersion.setArtifactoryPath(bundledAppVersionRequest.getArtifactoryPath());
        bundleReleaseAppVersion.setProductVersions(versions);
        return bundleReleaseAppVersion;
    }
}
