#!/bin/sh

# start the Opentest server in the background
(cd server && opentest server &)

echo "Waiting for opentest server to start..."
attempts=1
timeout=30
# curl the server until it responds or the timeout is reached
until $(curl --output /dev/null --silent --head --fail localhost:3000) || [[ $attempts -gt $timeout ]]; do
    printf '.'
    sleep 1
    attempts=$((attempts+1))
done
if [[ $attempts -gt $timeout ]]; then
  echo "Opentest server failed to start in time, exiting"
  exit 1
fi

echo "Opentest server started successfully"
opentest actor actors/actor &

echo "Waiting for actor to start..."
sleep 5

# run opentest and squash error as a "failed" test shouldn't end the job
opentest session create --server http://localhost:3000 --template "AllTests" --wait --out /results/junit.xml || true
