# Quickstart

## Dependencies
- Docker
- NPM
- Opentest
- MySQL

## Environment Variables
Set `BASE_URL` which sets the URL the tests will use to access the restaurant service:
```
export BASE_URL="http://localhost:8080"
```
Note that this needs to be set for the Opentest actor process.

## Run the service
Build the container
```
docker build -t restaurant-assets .
```

Start the service
```
docker run -p 8080:8080 -e spring_profiles_active=opentest -e MYSQL_DATASOURCE_URL=<datasource> -e MYSQL_DATASOURCE_USERNAME=<username> -e MYSQL_DATASOURCE_PASSWORD=<password> restaurant-assets
```
The default MySQL url is `jdbc:mysql://host.docker.internal:3306/opentest`.

## Start Opentest
Install Opentest if it hasn't been already:
```
npm install opentest -g
```

From `src/test/opentest/server` run:
```
opentest server
```

This will start the opentest server. In a new terminal, navigate to `src/test/opentest/actor` and run:
```
opentest actor actor1
```

This will start one of the test actors which will watch for a test session to execute.

## Create a Test Session
With the server and a test actor running, a test session can be started either by navigating to the UI (`localhost:3000` by default) or via the command line:
```
opentest session create --server http://localhost:3000 --template "AllTests" --wait --out junit.xml
```
This will start a test session which will run the tests. The `--template` flag determines which set of tests are run. The `--out` flag indicates the file to save test results to. The output for the above command should look something like:
```
Started test session 1581376513
Session completion timeout is set to 7200 seconds
Waiting for the test session to complete...
```
Logs for the tests themselves will appear in the actor process. Once the tests complete, the test results file will appear in the current directory. Alternatively, the results can be queried from the server using the test session ID:
```
curl http://localhost:3000/api/session/1581376513?format=junit
```

# TBD
Custom JAR files can be added to the `user-jars` directory within each actor directory (e.g. opentest/actors/actor1/user-jars). These JARs extend opentest functionality with additional custom keywords that can be called from within the tests.
