package com.mcd.restaurant.reip;

import com.mcd.restaurant.reip.controller.RestaurantEdgeIOTController;
import com.mcd.restaurant.reip.error.RestaurantEdgeIOTException;
import com.mcd.restaurant.reip.services.RestaurantEdgeIOTService;
import com.mcd.restaurant.reip.services.RestaurantEdgeIOTValidator;
import com.mcd.restaurant.reip.view.request.DeviceAdapterOnboardingRequestDTO;
import com.mcd.restaurant.reip.view.request.DeviceRequestDTO;
import com.mcd.restaurant.reip.view.request.PropRequestDTO;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import java.util.ArrayList;
import java.util.List;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.jupiter.api.Assertions.assertThrows;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
class RestaurantEdgeIOTControllerTest {
    private RequestSpecification spec;

    @LocalServerPort
    int port;
    @InjectMocks
    private RestaurantEdgeIOTController restaurantEdgeIOTController;
    @Mock
    private RestaurantEdgeIOTService restaurantEdgeIOTService;
    @Mock
    private RestaurantEdgeIOTValidator restaurantEdgeIOTValidator;


    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation)
                        .operationPreprocessors().withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
    void postOnboardAdapterSuccess() {
        String jsonBody = "{\n" +
                "    \"storeId\": 1,\n" +
                "    \"devices\": [\n" +
                "        {\n" +
                "            \"name\": \"New-Adapter\",\n" +
                "            \"deviceTypeId\": 1,\n" +
                "            \"serialNumber\": \"2345334\",\n" +
                "            \"modelNumber\": \"3213\",\n" +
                "            \"firmwareVersion\": \"2.1\",\n" +
                "            \"status\": \"Onboarded\",\n" +
                "            \"createdBy\": \"ABC\",\n" +
                "            \"props\": [\n" +
                "                {\n" +
                "                    \"propName\": \"ipAddress\",\n" +
                "                    \"propValue\": \"1.2.3.4\"\n" +
                "                }\n" +
                "            ]\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .post("/reip/onboard/device")
                .then().assertThat().statusCode(is(201));
    }


    @Test
    void postOnboardNonAdapterSuccess() {
        String jsonBody = "{\n" +
                "    \"storeId\": 1,\n" +
                "    \"devices\": [\n" +
                "        {\n" +
                "            \"name\": \"New-Adapter2\",\n" +
                "            \"deviceTypeId\": 2,\n" +
                "            \"serialNumber\": \"2345334\",\n" +
                "            \"modelNumber\": \"3213\",\n" +
                "            \"firmwareVersion\": \"3.1\",\n" +
                "            \"status\": \"Onboarded\",\n" +
                "            \"adapterId\": 1,\n" +
                "            \"connectorId\": 1,\n" +
                "            \"createdBy\": \"ABC\",\n" +
                "            \"props\": [\n" +
                "                {\n" +
                "                    \"propName\": \"ipAddress\",\n" +
                "                    \"propValue\": \"1.2.3.4\"\n" +
                "                }\n" +
                "            ]\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .post("/reip/onboard/device")
                .then().assertThat().statusCode(is(201));
    }

    @Test
    void postOnboardNonAdapterWithDeviceTypeAsNull() {
        String jsonBody = "{\n" +
                "    \"storeId\": 1,\n" +
                "    \"devices\": [\n" +
                "        {\n" +
                "            \"name\": \"New-Adapter2\",\n" +
                "            \"deviceTypeId\": null,\n" +
                "            \"serialNumber\": \"2345334\",\n" +
                "            \"modelNumber\": \"3213\",\n" +
                "            \"firmwareVersion\": \"3.1\",\n" +
                "            \"status\": \"Onboarded\",\n" +
                "            \"adapterId\": 1,\n" +
                "            \"connectorId\": 1,\n" +
                "            \"createdBy\": \"ABC\",\n" +
                "            \"props\": [\n" +
                "                {\n" +
                "                    \"propName\": \"ipAddress\",\n" +
                "                    \"propValue\": \"1.2.3.4\"\n" +
                "                }\n" +
                "            ]\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .post("/reip/onboard/device")
                .then().assertThat().statusCode(is(400));
    }
    @Test
    void postOnboardVendorWithAdapterTypeSuccess() {
        String jsonBody = "{\n" +
                "  \"isReIP\": \"Yes\",\n" +
                "  \"vendorName\": \"test-vendor\",\n" +
                "  \"vendorNotes\": \"test-notes\",\n" +
                "  \"vendorContact\": {\n" +
                "    \"name\": \"John Doe\",\n" +
                "    \"email\": \"john.doe@test.com\",\n" +
                "    \"phone\": 63725821\n" +
                "  },\n" +
                "  \"deviceTypes\": [\n" +
                "    {\n" +
                "      \"category\": \"Universal Adapter\",\n" +
                "      \"deviceType\": \"ta-1121\",\n" +
                "      \"connectors\": [\n" +
                "        \"USB-1\",\n" +
                "        \"USB-2\",\n" +
                "        \"Serial-1\"\n" +
                "      ],\n" +
                "      \"attributes\": [\n" +
                "        \"IP Address\",\n" +
                "        \"Hardware Version\"\n" +
                "      ]\n" +
                "    }\n" +
                "  ],\n" +
                "  \"createdBy\": \"TestUser\"\n" +
                "}";

        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .post("/reip/onboard/vendor")
                .then().assertThat().statusCode(is(201));
    }

    @Test
    void postOnboardVendorWithDeviceTypeSuccess() {
        String jsonBody = "{\n" +
                "  \"isReIP\": \"Yes\",\n" +
                "  \"vendorName\": \"test-vendor\",\n" +
                "  \"vendorNotes\": \"test-notes\",\n" +
                "  \"vendorContact\": {\n" +
                "    \"name\": \"John Doe\",\n" +
                "    \"email\": \"john.doe@vendor.com\",\n" +
                "    \"phone\": 123455\n" +
                "  },\n" +
                "  \"deviceTypes\": [\n" +
                "    {\n" +
                "      \"category\": \"Device\",\n" +
                "      \"deviceType\": \"Fryer\",\n" +
                "      \"isMQTTEnabled\": true,\n" +
                "      \"isOTAEnabled\": true,\n" +
                "      \"attributes\": [\n" +
                "        \"IP Address\",\n" +
                "        \"Hardware Version\"\n" +
                "      ]\n" +
                "    }\n" +
                "  ],\n" +
                "  \"createdBy\": \"TestUser\"\n" +
                "}";

        RestAssured.given(this.spec)
                .accept("application/json")
                .contentType("application/json")
                .body(jsonBody)
                .when()
                .post("/reip/onboard/vendor")
                .then().assertThat().statusCode(is(201));
    }
}
