package com.mcd.restaurant.bundleRelease;

import com.mcd.restaurant.bundledrelease.controller.view.request.DeployBundleReleaseAppCheckDTO;
import com.mcd.restaurant.common.MapperUtils;
import com.mcd.restaurant.model.Restaurant;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
class MapperUtilTest {
    private RequestSpecification spec;
    @LocalServerPort
    int port;

    @InjectMocks
    private MapperUtils mapperUtils;

    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation).operationPreprocessors()
                        .withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
    void mapSingleTest() {
        Restaurant restaurant = new Restaurant();
        restaurant.setId(1);
        restaurant.setName("Test");
        Assertions.assertTrue(mapperUtils.map(restaurant, DeployBundleReleaseAppCheckDTO.class) instanceof DeployBundleReleaseAppCheckDTO);
    }

    @Test
    void mapMultipleTest() {
        Restaurant restaurant = new Restaurant();
        restaurant.setId(1);
        restaurant.setName("Test");
        Assertions.assertTrue(mapperUtils.map(Stream.of(restaurant).collect(Collectors.toList()), DeployBundleReleaseAppCheckDTO.class) instanceof List);
    }

    @Test
    void mapMultipleTypeTest() {
        Restaurant restaurant = new Restaurant();
        restaurant.setId(1);
        restaurant.setName("Test");
        List<DeployBundleReleaseAppCheckDTO> list = mapperUtils.map(Stream.of(restaurant).collect(Collectors.toList()), DeployBundleReleaseAppCheckDTO.class);
        Assertions.assertEquals(1, list.size());
        Assertions.assertTrue(list.get(0) instanceof DeployBundleReleaseAppCheckDTO);
    }

}
