package com.mcd.restaurant;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import net.minidev.json.JSONObject;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import static org.hamcrest.CoreMatchers.is;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
 class ReipJobValidationTests {

    private RequestSpecification spec;

    @LocalServerPort
    int port;

    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation).operationPreprocessors()
                        .withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
     void getReipJobValidationWhenIDIsInvalid() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/reip_job_validation/123")
                .then().assertThat().statusCode(is(404));
    }

    @Test
     void getReipJobValidationWhenIDIsNull() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/reip_job_validation/null")
                .then().assertThat().statusCode(is(500));
    }

    @Test
     void getReipJobValidationWhenIDIsMissing() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/reip_job_validation/").then()
                .statusCode(is(200));
    }

    @Test
     void postReipJobValidationWhenInputJSONIsEmpty() {
        String jsonBody = "";

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
                .post("/restaurant_assets/reip_job_validation").then().assertThat().statusCode(is(400));
    }

    @Test
     void postReipJobValidationWhenInputJSONIsInvalid() {
        String jsonBody = "{}";

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
                .post("/restaurant_assets/reip_job_validation").then().assertThat().statusCode(is(400));
    }

    @Test
     void postReipJobValidationWhenInputJSONIsValid() {
        JSONObject body = new JSONObject();
        JSONObject dataJSON = new JSONObject();
       JSONObject subDataJSON = new JSONObject();
       JSONObject outerDataJSON = new JSONObject();
       JSONObject relationShipJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("device_name", "Dev123");
        attributeJSON.put("row_id", "0");
        attributeJSON.put("missing_values", "col3");
        attributeJSON.put("invalid_values", "col1,col2");
        subDataJSON.put("type", "reip_onboarding_jobs");
        subDataJSON.put("id", 1);
        outerDataJSON.put("data", subDataJSON);
        relationShipJSON.put("reipOnboardingJob", outerDataJSON);
        // fill data JSON
        dataJSON.put("type", "reip_job_validation");
        dataJSON.put("attributes", attributeJSON);
        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);
        System.out.println(body);
        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/reip_job_validation").then().assertThat().statusCode(is(201));
    }
}