package com.mcd.restaurant;


import com.mcd.restaurant.bundledrelease.controller.view.response.SchedulerTimeResponse;
import com.mcd.restaurant.model.DeploymentHistory;
import com.mcd.restaurant.repository.DeploymentHistoryRepository;
import com.mcd.restaurant.scheduler.DeploymentStatusUpdateScheduler;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.util.ReflectionTestUtils;

import java.util.List;


import static org.junit.jupiter.api.Assertions.*;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
class DeploymentStatusUpdateSchedulerTest {
    private RequestSpecification spec;

    @LocalServerPort
    int port;
    @Mock
    private DeploymentStatusUpdateScheduler deploymentStatusUpdateScheduler;
    @Autowired
    private DeploymentHistoryRepository deploymentHistoryRepository;
    @Mock
    private DeploymentHistoryRepository deploymentHistoryRepositoryMock;
    @InjectMocks
    private DeploymentStatusUpdateScheduler deploymentStatusUpdateSchedulerReal;

    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation).operationPreprocessors()
                        .withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
    void testScheduler() {
        ResourceList<DeploymentHistory> list = new DefaultResourceList<>();
        ReflectionTestUtils.setField(deploymentStatusUpdateSchedulerReal, "failAfterTime", 60l);
        ReflectionTestUtils.setField(deploymentStatusUpdateSchedulerReal, "deploymentHistoryRepository", deploymentHistoryRepository);
        Mockito.when(deploymentHistoryRepositoryMock.findAll(Mockito.any(QuerySpec.class))).thenReturn(list);
        deploymentStatusUpdateSchedulerReal.cronJobToUpdateDeploymentStatus();
        List<DeploymentHistory> deploymentHistoryList = deploymentHistoryRepository.findAll(deploymentStatusUpdateSchedulerReal.prepareQuerySpecFilterForSingleVersionInBundleAppVersion());
        assertEquals(0, deploymentHistoryList.size());
    }


    @Test
    void testSchedulerTimeResponse() {
        SchedulerTimeResponse schedulerTimeResponse = SchedulerTimeResponse.builder().failAfter(4l).fixedDelay(4l).intialDelay(4l).build();
        assertNotNull(schedulerTimeResponse);
        assertNotNull(new SchedulerTimeResponse());
        assertEquals(4l, (long) schedulerTimeResponse.getFailAfter());
        assertEquals(4l, (long) schedulerTimeResponse.getFixedDelay());
        assertEquals(4l, (long) schedulerTimeResponse.getIntialDelay());

    }

}
