package com.mcd.restaurant;


import com.mcd.restaurant.bundledrelease.controller.view.request.DeployBundleReleaseAppCheckDTO;
import com.mcd.restaurant.bundledrelease.controller.view.request.MetaDataDetails;
import com.mcd.restaurant.model.HierarchyNode;
import com.mcd.restaurant.model.Market;
import com.mcd.restaurant.repository.DeployBundleReleaseAppVersionResourceRepository;
import io.crnk.core.exception.MethodNotAllowedException;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import java.sql.Date;
import java.sql.Timestamp;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.jupiter.api.Assertions.*;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
class DeployBundleReleaseAppCheckTest {
    @InjectMocks
    private DeployBundleReleaseAppVersionResourceRepository deployBundleReleaseAppVersionResourceRepository;

    private RequestSpecification spec;

    @LocalServerPort
    int port;

    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation)
                        .operationPreprocessors().withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
    void getBundleWhenSourceIDIsMissing() {
        RestAssured.given(this.spec).accept("application/json").when().get("restaurant_assets/restaurant_report?include=hierarchyNode&page[limit]=-1&filter[targetBundleId]=98").then()
                .assertThat().statusCode(is(400));
    }

    @Test
    void getBundleWhenTargetIDIsMissing() {
        RestAssured.given(this.spec).accept("application/json").when().get("restaurant_assets/restaurant_report?include=hierarchyNode&filter[sourceBundleId]=97&page[limit]=-1").then()
                .assertThat().statusCode(is(400));
    }

    @Test
    void getBundleWhenIDIsInvalid() {
        RestAssured.given(this.spec).accept("application/json").when().get("restaurant_assets/restaurant_report?include=hierarchyNode&filter[sourceBundleId]=b&page[limit]=-1&filter[targetBundleId]=a").then()
                .assertThat().statusCode(is(500));
    }

    @Test
    void getBundleInfoWhenSuccess() {
        RestAssured.given(this.spec).accept("application/json").when().get("restaurant_assets/restaurant_report?include=hierarchyNode&filter[sourceBundleId]=1&page[limit]=-1&filter[targetBundleId]=2").then()
                .assertThat().statusCode(is(200));
    }

    @Test
    void testfindOne() {
        assertThrows(MethodNotAllowedException.class,
                () -> deployBundleReleaseAppVersionResourceRepository.findOne("1", null));
    }

    @Test
    void testDeployBundleAppCheckDTO() {
        HierarchyNode node = new HierarchyNode();
        Market market = new Market();
        Timestamp timestamp = new Timestamp(5);
        DeployBundleReleaseAppCheckDTO deployBundleReleaseAppCheckDTO = DeployBundleReleaseAppCheckDTO.builder().id(1).bundleId(1).description("test").hierarchyNode(node).name("abc").market(market).updated(timestamp).created(timestamp).build();
        assertNotNull(deployBundleReleaseAppCheckDTO);
        assertNotNull(new DeployBundleReleaseAppCheckDTO());
        assertEquals(1, deployBundleReleaseAppCheckDTO.getId());
        assertEquals(1, deployBundleReleaseAppCheckDTO.getBundleId());
        assertEquals("test", deployBundleReleaseAppCheckDTO.getDescription());
        assertEquals(node, deployBundleReleaseAppCheckDTO.getHierarchyNode());
        assertEquals("abc", deployBundleReleaseAppCheckDTO.getName());
        assertEquals(market, deployBundleReleaseAppCheckDTO.getMarket());
        assertEquals(timestamp, deployBundleReleaseAppCheckDTO.getCreated());
        assertEquals(timestamp, deployBundleReleaseAppCheckDTO.getUpdated());


    }

    @Test
    void testMetaDataDetailsTest() {
        MetaDataDetails metaDataDetails = MetaDataDetails.builder().metaDataCount(5).build();
        assertNotNull(metaDataDetails);
        assertEquals(5, (int) metaDataDetails.getMetaDataCount());
        assertNotNull(new MetaDataDetails());
    }


}
