package com.mcd.restaurant;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import net.minidev.json.JSONObject;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import static org.hamcrest.CoreMatchers.is;

@ExtendWith({SpringExtension.class, RestDocumentationExtension.class})
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles("test")
 class BundleReleaseAppVersionTests {
    private RequestSpecification spec;

    @LocalServerPort
    int port;

    @BeforeEach
    public void setUp(RestDocumentationContextProvider restDocumentation) {
        RestAssured.port = port;

        this.spec = new RequestSpecBuilder()
                .addFilter(RestAssuredRestDocumentation.documentationConfiguration(restDocumentation)
                        .operationPreprocessors().withResponseDefaults(Preprocessors.prettyPrint()))
                .build();
    }

    @Test
     void getBundleAppVersionWhenIDIsInvalid() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/bundle_release_app_version/198")
                .then().assertThat().statusCode(is(404));
    }

    @Test
     void getBundleAppVersionWhenIDIsNull() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/bundle_release_app_version/null")
                .then().assertThat().statusCode(is(500));
    }

    @Test
     void getBundleAppVersionWhenIDIsMissing() {
        RestAssured.given(this.spec).accept("application/json").when().get("/restaurant_assets/bundle_release_app_version/")
                .then().statusCode(is(200));
    }

    @Test
     void postBundleAppVersionWhenInputJSONIsEmpty() {
        String jsonBody = "";

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(400));
    }

    @Test
     void postBundleAppVersionWhenInputJSONIsInvalid() {
        String jsonBody = "{}";

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(jsonBody).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(400));
    }


    @Test
     void postBundleAppVersionWhenInputJSONIsInvalidDataKeyMissing() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        bundleReleaseDataJSON.put("id", "1");
        appDataJSON.put("id", "1");
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data2", dataJSON);

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(400));
    }

    @Test
     void postBundleAppVersionWhenbundleReleaseIDIsMissing() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        appDataJSON.put("id", "1");
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);
        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(500));
    }

    @Test
     void postBundleAppVersionWhenAppIdIsMissing() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        bundleReleaseDataJSON.put("id", "1");
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(500));
    }

    @Test
     void postBundleAppVersionWhenAppIdIsEmpty() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        bundleReleaseDataJSON.put("id", "2");
        appDataJSON.put("id", "");
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(500));
    }

    @Test
     void postBundleAppVersionWhenAppIdIsNull() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        bundleReleaseDataJSON.put("id", "2");
        appDataJSON.put("id", null);
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(500));
    }

    @Test
     void postBundleAppVersionWhenAppIdIsInvalid() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        bundleReleaseDataJSON.put("id", "1");
        appDataJSON.put("id", "abc");
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(500));
    }

    @Test
     void postBundleAppVersionWhenBundleRealeaseIdIsEmpty() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        bundleReleaseDataJSON.put("id", "");
        appDataJSON.put("id", "1");
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(500));
    }

    @Test
     void postBundleAppVersionWhenBundleReleaseIdIsNull() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        bundleReleaseDataJSON.put("id", null);
        appDataJSON.put("id", "1");
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(500));
    }

    @Test
     void postBundleAppVersionWhenBundleReleaseIdIsInvalid() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        bundleReleaseDataJSON.put("id", "1abce");
        appDataJSON.put("id", "1");
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(500));
    }

    @Test
     void patchHistoryWhenInputJSONIsEmptyString() {
        String body = "";

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body).when()
                .patch("/restaurant_assets/bundle_release_app_version/null").then().assertThat().statusCode(is(500));
    }

    @Test
     void postHistoryWhenReleaseIdAndAppIdAreEmpty() {
        JSONObject body = new JSONObject();
        JSONObject relationShipJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        JSONObject appJSON = new JSONObject();
        JSONObject bundleReleaseJSON = new JSONObject();
        JSONObject bundleReleaseDataJSON = new JSONObject();
        JSONObject appDataJSON = new JSONObject();
        JSONObject attributeJSON = new JSONObject();
        attributeJSON.put("version", "rel-asrservice-2021-09-25.rc1");
        attributeJSON.put("artifactoryPath", "artifactory.bre.mcd.com/docker/aidt-asrservic/rel-asrservice-2021-09-20.rc1");
        // fill data JSON
        dataJSON.put("type", "bundle_release_app_version");
        dataJSON.put("attributes", attributeJSON);
        // fill market and owner operator json
        bundleReleaseDataJSON.put("type", "bundle_release");
        bundleReleaseDataJSON.put("id", "");
        appDataJSON.put("id", "");
        appDataJSON.put("type", "app");

        bundleReleaseJSON.put("data", bundleReleaseDataJSON);
        appJSON.put("data", appDataJSON);
        relationShipJSON.put("bundleRelease", bundleReleaseJSON);
        relationShipJSON.put("app", appJSON);

        dataJSON.put("relationships", relationShipJSON);
        body.put("data", dataJSON);

        RestAssured.given(this.spec).contentType("application/vnd.api+json").body(body.toString()).when()
                .post("/restaurant_assets/bundle_release_app_version").then().assertThat().statusCode(is(500));
    }


}
