package com.mcd.restaurant.scheduler;


import com.mcd.restaurant.deployment.service.DeploymentStatus;
import com.mcd.restaurant.model.DeploymentHistory;
import com.mcd.restaurant.repository.DeploymentHistoryRepository;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component("deploymentStatusUpdateScheduler")
@Slf4j
public class DeploymentStatusUpdateScheduler {

    @Value("${scheduler.fail-after}")
    private Long failAfterTime;
    @Autowired
    private DeploymentHistoryRepository deploymentHistoryRepository;



    @Transactional
    @Scheduled(fixedDelayString = "${scheduler.fixed-delay}", initialDelayString = "${scheduler.initial-delay}")
    public void cronJobToUpdateDeploymentStatus() {
        log.info("DeploymentStatusUpdateScheduler initiated");
        List<DeploymentHistory> deploymentHistoryList = deploymentHistoryRepository.findAll(prepareQuerySpecFilterForSingleVersionInBundleAppVersion());
        deploymentHistoryList.forEach(i -> {
            i.setStatus(DeploymentStatus.Failed.value());
            i.setDescription("Deployment is marked as failed by the system");
            deploymentHistoryRepository.save(i);
        });
    }

    public QuerySpec prepareQuerySpecFilterForSingleVersionInBundleAppVersion() {
        FilterSpec filterStatus = new FilterSpec(PathSpec.of("status"), FilterOperator.EQ, DeploymentStatus.InProgress.value());
        FilterSpec filetrUpdatedAT = new FilterSpec(PathSpec.of("updated"), FilterOperator.LT, Timestamp.valueOf(LocalDateTime.now().minusMinutes(failAfterTime)));
        FilterSpec filterSpecFinal = FilterSpec.and(Stream.of(filterStatus, filetrUpdatedAT).collect(Collectors.toList()));
        QuerySpec querySpec = new QuerySpec(DeploymentHistory.class);
        querySpec.setFilters(Stream.of(filterSpecFinal).collect(Collectors.toList()));
        return querySpec;

    }
}
