package com.mcd.restaurant.repository;

import com.mcd.restaurant.dashboard.enums.HierarchyLevel;
import com.mcd.restaurant.model.StoreDemographic;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class StoreDemographicRepository extends JpaEntityRepositoryBase<StoreDemographic, Integer> {
    public StoreDemographicRepository() {
        super(StoreDemographic.class);
    }

    public QuerySpec prepareQuerySpecFilterForStoreDemographicMarketId(HierarchyLevel hierarchyLevel, Integer marketId) {
        QuerySpec querySpec = new QuerySpec(StoreDemographic.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of("hierarchyNode.hierarchyLevel"), FilterOperator.EQ, hierarchyLevel.value());
        FilterSpec filterMarketIdSpec = new FilterSpec(PathSpec.of("hierarchyNode.marketNodeId"), FilterOperator.EQ, marketId);
        FilterSpec filterSpecFinal = FilterSpec.and(Stream.of(filterSpec, filterMarketIdSpec).collect(Collectors.toList()));
        querySpec.setFilters(Stream.of(filterSpecFinal).collect(Collectors.toList()));
        return querySpec;
    }

    public QuerySpec prepareQuerySpecFilterForStoreDemographicHierarchyNodeId(Integer hierarchyNodeId) {
        QuerySpec querySpec = new QuerySpec(StoreDemographic.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of("hierarchyNode.id"), FilterOperator.EQ, hierarchyNodeId);
        querySpec.setFilters(Stream.of(filterSpec).collect(Collectors.toList()));
        return querySpec;
    }
}
