package com.mcd.restaurant.repository;


import com.mcd.restaurant.model.RestaurantView;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

import java.util.Set;


@Component
public class RestaurantViewRepository extends JpaEntityRepositoryBase<RestaurantView, Integer> {
    public RestaurantViewRepository() {
        super(RestaurantView.class);
    }

    public ResourceList<RestaurantView> getRestaurantDetailsById(Set<Integer> restaurantIds) {
        QuerySpec restaurantSpec = new QuerySpec(RestaurantView.class);
        restaurantSpec.addFilter(new FilterSpec(PathSpec.of("id"), FilterOperator.EQ, restaurantIds));
        return this.findAll(restaurantSpec);
    }
}