package com.mcd.restaurant.repository;


import com.mcd.restaurant.model.ProductVersions;
import com.mcd.restaurant.productversions.controller.view.request.ProductRequestDTO;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;


@Component
public class ProductVersionRepository extends JpaEntityRepositoryBase<ProductVersions, Integer> {
    public ProductVersionRepository() {
        super(ProductVersions.class);
    }

    public List<ProductVersions> getProductVersionByProductIdAndVersionName(Integer id, String versionName) {
        QuerySpec querySpec = new QuerySpec(ProductVersions.class);
        FilterSpec filterVersionSpec = new FilterSpec(PathSpec.of("versionName"), FilterOperator.EQ, versionName);
        FilterSpec filterProductSpec = new FilterSpec(PathSpec.of("products.id"), FilterOperator.EQ, id);
        FilterSpec filterSpecFinal = FilterSpec.and(Stream.of(filterVersionSpec, filterProductSpec).collect(Collectors.toList()));
        querySpec.setFilters(Stream.of(filterSpecFinal).collect(Collectors.toList()));
        return this.findAll(querySpec);
    }


    public List<ProductVersions> getAllApplicationByProductNameAndVersion(List<ProductRequestDTO> productVersion) {
        QuerySpec querySpec = new QuerySpec(ProductVersions.class);
        List<FilterSpec> filterSpecList = new ArrayList<>();
        productVersion.forEach(i -> {
            FilterSpec filterNameSpec = new FilterSpec(PathSpec.of("products.name"), FilterOperator.EQ, i.getProductName());
            FilterSpec filterVersionSpec = new FilterSpec(PathSpec.of("versionName"), FilterOperator.EQ, i.getVersionName());
            filterSpecList.add(FilterSpec.and(Stream.of(filterNameSpec, filterVersionSpec).collect(Collectors.toList())));
        });
        querySpec.addFilter(FilterSpec.or(filterSpecList));
        return this.findAll(querySpec);
    }


}