package com.mcd.restaurant.repository;

import com.mcd.restaurant.dashboard.utils.StoreDashboardConstants;
import com.mcd.restaurant.model.HardwareDetail;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.data.jpa.JpaEntityRepositoryBase;
import org.springframework.stereotype.Component;

import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class HardwareDetailRepository extends JpaEntityRepositoryBase<HardwareDetail, Integer> {
    public HardwareDetailRepository() {
        super(HardwareDetail.class);
    }

    public QuerySpec prepareQuerySpecFilterForHardwareDetail(Integer restaurantId) {
        QuerySpec querySpec = new QuerySpec(HardwareDetail.class);
        FilterSpec filterSpec = new FilterSpec(PathSpec.of(StoreDashboardConstants.RESTAURANT_ID), FilterOperator.EQ, restaurantId);
        querySpec.setFilters(Stream.of(filterSpec).collect(Collectors.toList()));
        return querySpec;
    }
}
