package com.mcd.restaurant.repository;

import com.mcd.restaurant.deployment.controller.view.beans.DeploymentQueueData;
import com.mcd.restaurant.model.DeploymentGroup;
import com.mcd.restaurant.model.DeploymentHistory;
import com.mcd.restaurant.model.Restaurant;
import io.crnk.core.exception.InternalServerErrorException;
import io.crnk.core.exception.MethodNotAllowedException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryBase;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

@Component
public class DeploymentQueueDataRepository extends ResourceRepositoryBase<DeploymentQueueData, Integer> {

    @Autowired
    private DeploymentGroupRepository deploymentGroupRepository;

    public DeploymentQueueDataRepository() {
        super(DeploymentQueueData.class);
    }

    @Override
    public DeploymentQueueData findOne(Integer id, QuerySpec querySpec) {
        throw new MethodNotAllowedException("method not allowed");

    }

    /**
     * This method will find the list of stores that eligible for bundle deployment
     */
    @Override
    public ResourceList<DeploymentQueueData> findAll(QuerySpec querySpec) {
        try {
            ResourceList<DeploymentQueueData> dtoList = new DefaultResourceList<>();
            QuerySpec deploymentGroupQuerySpec = new QuerySpec(DeploymentGroup.class);
            deploymentGroupQuerySpec.setFilters(querySpec.getFilters());
            deploymentGroupQuerySpec.setPaging(querySpec.getPaging());
            deploymentGroupQuerySpec.setSort(querySpec.getSort());
            ResourceList<DeploymentGroup> deploymentGroupList = deploymentGroupRepository.findAll(deploymentGroupQuerySpec);
            deploymentGroupList.forEach(group -> {
                Set<Restaurant> restaurantSet = new HashSet<>();
                String restaurantDetails = "";
                for (DeploymentHistory history : group.getDeploymentHistory()) {
                    restaurantDetails = history.getRestaurant().getName();
                    restaurantSet.add(history.getRestaurant());
                    if (restaurantSet.size() > 1) {
                        restaurantDetails = "Multiple Stores";
                        break;
                    }
                }
                dtoList.add(DeploymentQueueData.builder()
                        .id(group.getId())
                        .status(group.getStatus())
                        .scheduled(group.getScheduled())
                        .deployedBy(group.getDeployedBy())
                        .deployedVersion(group.getDeployedVersion())
                        .deploymentName(group.getDeploymentTag() != null ? group.getDeploymentTag().getName() : "").restaurantDetail(restaurantDetails).type(group.getType()).created(group.getCreated()).build());
            });
            return new DefaultResourceList<>(dtoList, deploymentGroupList.getMeta(), null);
        } catch (Exception e) {
            throw new InternalServerErrorException("Some Exception Ocurred. Cannot process the request");
        }

    }


}