package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name="vendors", indexes={@Index(name="vendors_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "vendors")
public class Vendor implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;
    
    @Column(nullable=false)
    private String name;
    
    @CreationTimestamp
    private Timestamp created;
    
    @UpdateTimestamp
    private Timestamp updated;

    @Lob
    @Column(name="notes", length=1024)
    private String notes;

    @OneToMany(mappedBy="vendor")
    @JsonIgnoreProperties("vendor")
    @JsonApiRelation(mappedBy = "vendor")
    @ToString.Exclude
    private List<Component> components;

    @OneToMany(mappedBy="vendor")
    @JsonIgnoreProperties("vendor")
    @JsonApiRelation(mappedBy = "vendor")
    @ToString.Exclude
    private List<Device> device;

    @OneToMany(mappedBy="vendors")
    @JsonIgnoreProperties("vendors")
    @JsonApiRelation(mappedBy = "vendors")
    @ToString.Exclude
    private List<VendorContacts> vendor_contacts;

}