package com.mcd.restaurant.model;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name="template_app", indexes={@Index(name="template_app_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "template_app")
public class TemplateApp implements Serializable {
    @Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @ManyToOne
    @JoinColumn(name="template_id", nullable=false)
    @JsonIgnoreProperties("template")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Template template;

    @ManyToOne
    @JoinColumn(name="app_id", nullable=false)
    @JsonIgnoreProperties("app")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private App app;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;
}