package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name="reip_vendors", indexes={@Index(name="reip_vendors_id_IX", columnList="id", unique=true)})
@Builder
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@JsonApiResource(type = "reip_vendors")
public class ReipVendor implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;
    
    @Column(nullable=false)
    private String name;

    @Lob
    @Column(name="vendor_notes", length=1024)
    private String vendorNotes;

    @Column(nullable=false)
    private String contact_name;

    @Column(nullable=false)
    private String phone_number;

    @Column(nullable=false)
    private String email_id;

    @Lob
    @Column(name="contact_notes", length=1024)
    private String contactNotes;

    @CreationTimestamp
    private Timestamp created;

    @Column(name = "created_by", nullable = false)
    private String createdBy;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToMany(mappedBy="reipVendor")
    @JsonApiRelation(mappedBy = "reipVendor")
    @JsonIgnoreProperties("reipVendor")
    @ToString.Exclude
    private List<ReipDeviceTypes> reipDeviceTypes;

}