package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name="reip_onboarding_jobs", indexes={@Index(name="reip_onboarding_jobs_id_IX", columnList="id", unique=true)})
@Builder
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@JsonApiResource(type = "reip_onboarding_jobs")
public class ReipOnboardingJob implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;
    
    @Column(nullable=false)
    private String name;

    @Column(nullable=false)
    private String status;

    @Column(name = "file_data")
    private String fileData;

    @Column(name = "success_row_count")
    private String successRowCount;

    @CreationTimestamp
    private Timestamp created;

    @Column(name = "submitted_by", nullable = false)
    private String submittedBy;

    @Column(name = "contact_email", nullable = false)
    private String email;

    @OneToMany(mappedBy="reipOnboardingJob")
    @JsonApiRelation(mappedBy = "reipOnboardingJob")
    @JsonIgnoreProperties("reipOnboardingJob")
    @ToString.Exclude
    private List<ReipJobValidation> reipJobValidations;

}