package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name = "reip_device_types", indexes = {@Index(name = "reip_device_types_id_IX", columnList = "id", unique = true)})
@Builder
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@JsonApiResource(type = "reip_device_types")
public class ReipDeviceTypes implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable = false)
    private String typeName;

    @Column(name = "is_adapter")
    private Boolean isAdapter;

    @Column(name = "is_mqtt_enabled")
    private Boolean isMQTTEnabled;

    @Column(name = "is_ota_enabled")
    private Boolean isOTAEnabled;

    @Column(name = "created_by")
    private String createdBy;

    @Column(name = "model_number")
    private String modelNumber;

    @Column(name = "firmware_version")
    private String firmwareVersion;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @ManyToOne
    @JoinColumn(name = "vendor_id", nullable = false)
    @JsonIgnoreProperties("reipDeviceTypes")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ReipVendor reipVendor;

    @OneToMany(mappedBy = "reipDeviceTypes")
    @JsonApiRelation(mappedBy = "reipDeviceTypes")
    @JsonIgnoreProperties("reipDeviceTypes")
    @ToString.Exclude
    private List<ReipDeviceInstances> reipDeviceInstances;

    @OneToMany(mappedBy = "reipDeviceTypes")
    @JsonApiRelation(mappedBy = "reipDeviceTypes")
    @JsonIgnoreProperties("reipDeviceTypes")
    @ToString.Exclude
    private List<ReipDeviceTypeProps> reipDeviceTypeProps;
}