package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name = "reip_blacklist_device", indexes = {@Index(name = "reip_blacklist_device_id_IX", columnList = "id", unique = true)}, uniqueConstraints = @UniqueConstraint(columnNames = {
        "device_instance_id"}))
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonApiResource(type = "reip_blacklist_device")
public class ReipBlacklistDevice implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @ManyToOne
    @JoinColumn(name = "restaurant_id", nullable = false)
    @JsonIgnoreProperties("reipBlacklistDevices")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Restaurant restaurant;

    @OneToOne
    @JoinColumn(name="device_instance_id", nullable=false, unique = true)
    @JsonIgnoreProperties("reipBlacklistDevice")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ReipDeviceInstances reipDeviceInstance;

    @Column(nullable = false)
    private String notes;

    @Column(name = "status", nullable = false)
    private String status;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;
}