package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name = "hardware_details", indexes = {@Index(name = "hardware_details_id_IX", columnList = "id", unique = true)},uniqueConstraints = @UniqueConstraint(columnNames = {
        "mac_address", "serial_address","model_number","restaurant_id"}))
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "hardware_details")
public class HardwareDetail implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(name = "mac_address")
    private String macAddress;

    @Column(name = "serial_address")
    private String serialNumber;

    @Column(name = "model_number")
    private String model_number;


    @ManyToOne
    @JoinColumn(name = "restaurant_id", nullable = false)
    @JsonIgnoreProperties("hardwareDetails")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Restaurant restaurant;


    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;


}
