package com.mcd.restaurant.model;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name="device", indexes={@Index(name="device_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "device")
public class Device implements Serializable {
    @Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(name="name", nullable=false)
    private String name;

    @Column(name="abbreviation")
    private String abbreviation;

    @CreationTimestamp
    private Timestamp created;

    @OneToMany(mappedBy="device")
    @JsonIgnoreProperties("device")
    @JsonApiRelation(mappedBy = "device")
    @ToString.Exclude
    private List<DeviceProp> deviceProp;

    @ManyToOne
    @JoinColumn(name="vendor_id", nullable=false)
    @JsonIgnoreProperties("device")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Vendor vendor;

    @Column(name="device_flag", nullable=false)
    private Boolean deviceFlag;
}