package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Entity
@Data
@Table(name="component_type", indexes={@Index(name="component_type_id_IX", columnList="id", unique=true)})
@NoArgsConstructor
@JsonApiResource(type = "component_type")
public class ComponentType implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;
    
    @Column(unique=true, nullable=false)
    private String name;
    
    @Column
    private String description;
    
    @CreationTimestamp
    private Timestamp created;
    
    @UpdateTimestamp
    private Timestamp updated;
    
    @OneToMany(mappedBy="type")
    @JsonIgnoreProperties("type")
    @JsonApiRelation(mappedBy="type")
    @ToString.Exclude
    private List<Component> components;
}
