package com.mcd.restaurant.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;

import java.io.Serializable;
import java.sql.Timestamp;

@Entity
@Data
@Table(name="component_props", indexes={@Index(name="component_props_id_IX", columnList="id", unique=true)})
@Getter
@Setter
@NoArgsConstructor
@JsonApiResource(type = "component_props")
public class ComponentProp implements Serializable {
	@Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;
    
    @Column(name="property_name", nullable=false)
    private String propertyName;
    
    @Column(name="property_value", nullable=false)
    private String propertyValue;
    
    @CreationTimestamp
    private Timestamp created;
    
    @UpdateTimestamp
    private Timestamp updated;
    
    @ManyToOne
    @JoinColumn(name="component_id", nullable=false)
    @JsonIgnoreProperties("componentProps")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Component component;
    
    @ManyToOne
    @JoinColumn(name="type", referencedColumnName = "name")
    @JsonIgnoreProperties("componentProps")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ComponentPropertiesType type;
}
